unit QCard32;
  
interface

uses
  WinTypes;

const { Some useful constants: }
  CARDWIDTH = 71;
  CARDHEIGHT = 96;
  OFFSET = 16;

{ Declarations for all QCard32.dll procs and functions: }

{ Required in Form's FormCreate proc to use dll: }
function InitializeDeck(hWindow: HWND): Boolean; far; StdCall; { Check return! }
{ Reset all card values to defaults: }
procedure SetDefaultValues; far; StdCall;
{ Set the currently used card back design for cards 105 to 109: }
procedure SetCurrentBack(nIndex: Integer); far; StdCall;

{ Card drawing procs: }
procedure DrawSymbol(hWindow: hWnd; nValue, x, y: Integer); far; StdCall;
procedure DrawCard(hWindow: hWnd; nCard, x, y: Integer); far; StdCall;
procedure DrawBack(hWindow: hWnd; nValue, x, y: Integer); far; StdCall;
procedure DealCard(hWindow: hWnd; nCard, x, y: Integer); far; StdCall;
procedure RemoveCard(hWindow: hWnd; Value1: Integer); far; StdCall;

{ Fetch card information functions: }
function GetCardColor(nCard: Integer): Integer; far; StdCall;
function GetCardSuit(nCard: Integer): Integer; far; StdCall;
function GetCardValue(nCard: Integer): Integer; far; StdCall;
function GetCardStatus(nCard: integer): Boolean; far; StdCall;{ Faceup = True, Facedown = False }
function GetCardBlocked(nCard: Integer): Boolean; far; StdCall;
function IsCardDisabled(nCard: Integer): Boolean; far; StdCall;
function GetCardX(nCard: Integer): Integer; far; StdCall;
function GetCardY(nCard: Integer): Integer; far; StdCall;
function GetUser1(nCard: Integer): Boolean; far; StdCall;
function GetUser2(nCard: Integer): Integer; far; StdCall;
function GetUser3(nCard: Integer): Integer; far; StdCall;
function GetUser4(nCard: Integer): Integer; far; StdCall;

{ Change card data procs: }
procedure SetOffSet(nValue: Integer); far; StdCall; { set the offset in pixels for cards in columns for hit-testing }
procedure SetCardStatus(nCard: Integer; bValue: Boolean); far; StdCall; { Faceup = True, Facedown = False }
procedure AdjustCardBlocked(nCard: Integer; bValue: Boolean); far; StdCall;
procedure SetCardDisabled(nCard: Integer; bValue: Boolean); far; StdCall;
procedure SetCardX(nCard, x: Integer); far; StdCall;
procedure SetCardY(nCard, y: Integer); far; StdCall;
procedure SetUser1(nCard: Integer; bValue: Boolean); far; StdCall;
procedure SetUser2(nCard, nValue: Integer); far; StdCall;
procedure SetUser3(nCard, nValue: Integer); far; StdCall;
procedure SetUser4(nCard, nValue: Integer); far; StdCall;

{ Dragging procs and functions: }
function InitDrag(hWindow: hWnd; x, y: Integer): Integer; far; StdCall;
procedure AbortDrag; far; StdCall;
procedure DoDrag(hWindow: hWnd; x, y: Integer); far; StdCall;
function EndDrag(hWindow: hWnd; x, y: Integer): Integer; far; StdCall;
procedure ReturnDrag(hWindow: hWnd; nCard, nOldX, nOldY: Integer); far; StdCall;
procedure BlockDrag(hWindow: hWnd; var nFirst: Integer; nNumCards, x, y: Integer); far; StdCall;
function EndBlockDrag(hWindow: hWnd; var nFirst: Integer; nNumCards, x, y: Integer): Integer; far; StdCall;
procedure ReturnBlockDrag(hWindow: hWnd; var nFirst: Integer; nNumCards, x, y: Integer); far; StdCall;
function GetFreeDestination(nSource: Integer): Integer; far; StdCall;

{ Undocumented functions, generally not used: }

{ Returns the number of any unblocked card which lies beneath the mouse coordinates x, y: }
function PointInFreeCard(x, y: Integer): Integer; far; StdCall;

{ Returns the number of any card whose top 16 pixels lie beneath the mouse coordinates x, y: }
function PointInCardTop(Value1, Value2: Integer): Integer; far; StdCall;

{ Manually sets the active drag card for a subsequent DoDrag or BlockDrag call: }
procedure SetActiveCard(Value: Integer); far; StdCall;


implementation

function InitializeDeck(hWindow: HWND): Boolean; far; StdCall; external 'QCard32.dll' name 'InitializeDeck';
procedure SetDefaultValues; far; StdCall; external 'QCard32.dll' name 'SetDefaultValues';
procedure SetCurrentBack(nIndex: Integer); far; StdCall; external 'QCard32.dll' name 'SetCurrentBack';

procedure DrawSymbol(hWindow: hWnd; nValue, x, y: Integer); far; StdCall; external 'QCard32.dll' name 'DrawSymbol';
procedure DrawCard(hWindow: hWnd; nCard, x, y: Integer); far; StdCall; external 'QCard32.dll' name 'DrawCard';
procedure DrawBack(hWindow: hWnd; nValue, x, y: Integer); far; StdCall; external 'QCard32.dll' name 'DrawBack';
procedure DealCard(hWindow: hWnd; nCard, x, y: Integer); far; StdCall; external 'QCard32.dll' name 'DealCard';
procedure RemoveCard(hWindow: hWnd; Value1: Integer); far; StdCall; external 'QCard32.dll' name 'RemoveCard';

function GetCardColor(nCard: Integer): Integer; far; StdCall; external 'QCard32.dll' name 'GetCardColor';
function GetCardSuit(nCard: Integer): Integer; far; StdCall; external 'QCard32.dll' name 'GetCardSuit';
function GetCardValue(nCard: Integer): Integer; far; StdCall; external 'QCard32.dll' name 'GetCardValue';
function GetCardStatus(nCard: integer): Boolean; far; StdCall; external 'QCard32.dll' name 'GetCardStatus';
function GetCardBlocked(nCard: Integer): Boolean; far; StdCall; external 'QCard32.dll' name 'GetCardBlocked';
function IsCardDisabled(nCard: Integer): Boolean; far; StdCall; external 'QCard32.dll' name 'IsCardDisabled';
function GetCardX(nCard: Integer): Integer; far; StdCall; external 'QCard32.dll' name 'GetCardX';
function GetCardY(nCard: Integer): Integer; far; StdCall; external 'QCard32.dll' name 'GetCardY';
function GetUser1(nCard: Integer): Boolean; far; StdCall; external 'QCard32.dll' name 'GetUser1';
function GetUser2(nCard: Integer): Integer; far; StdCall; external 'QCard32.dll' name 'GetUser2';
function GetUser3(nCard: Integer): Integer; far; StdCall; external 'QCard32.dll' name 'GetUser3';
function GetUser4(nCard: Integer): Integer; far; StdCall; external 'QCard32.dll' name 'GetUser4';

procedure SetOffSet(nValue: Integer); far; StdCall; external 'QCard32.dll' name 'SetOffSet';
procedure SetCardStatus(nCard: Integer; bValue: Boolean); far; StdCall; external 'QCard32.dll' name 'SetCardStatus';
procedure AdjustCardBlocked; far; StdCall; external 'QCard32.dll' name 'AdjustCardBlocked';
procedure SetCardDisabled; far; StdCall; external 'QCard32.dll' name 'SetCardDisabled';
procedure SetCardX; far; StdCall; external 'QCard32.dll' name 'SetCardX';
procedure SetCardY; far; StdCall; external 'QCard32.dll' name 'SetCardY';
procedure SetUser1; far; StdCall; external 'QCard32.dll' name 'SetUser1';
procedure SetUser2; far; StdCall; external 'QCard32.dll' name 'SetUser2';
procedure SetUser3; far; StdCall; external 'QCard32.dll' name 'SetUser3';
procedure SetUser4; far; StdCall; external 'QCard32.dll' name 'SetUser4';

function InitDrag(hWindow: hWnd; x, y: Integer): Integer; far; StdCall; external 'QCard32.dll' name 'InitDrag';
procedure AbortDrag; far; StdCall; external 'QCard32.dll' name 'AbortDrag';
procedure DoDrag(hWindow: hWnd; x, y: Integer); far; StdCall; external 'QCard32.dll' name 'DoDrag';
function EndDrag(hWindow: hWnd; x, y: Integer): Integer; far; StdCall; external 'QCard32.dll' name 'EndDrag';
procedure ReturnDrag(hWindow: hWnd; nCard, nOldX, nOldY: Integer); far; StdCall; external 'QCard32.dll' name 'ReturnDrag';
procedure BlockDrag(hWindow: hWnd; var nFirst: Integer; nNumCards, x, y: Integer); far; StdCall; external 'QCard32.dll' name 'BlockDrag';
function EndBlockDrag(hWindow: hWnd; var nFirst: Integer; nNumCards, x, y: Integer): Integer; far; StdCall; external 'QCard32.dll' name 'EndBlockDrag';
procedure ReturnBlockDrag(hWindow: hWnd; var nFirst: Integer; nNumCards, x, y: Integer); far; StdCall; external 'QCard32.dll' name 'ReturnBlockDrag';
function GetFreeDestination(nSource: Integer): Integer; far; StdCall; external 'QCard32.dll' name 'GetFreeDestination';

function PointInFreeCard(x, y: Integer): Integer; far; StdCall; external 'QCard32.dll' name 'PointInFreeCard';
function PointInCardTop(Value1, Value2: Integer): Integer; far; StdCall; external 'QCard32.dll' name 'PointInCardTop';
procedure SetActiveCard(Value: Integer); far; StdCall; external 'QCard32.dll' name 'SetActiveCard';

end.



